//+------------------------------------------------------------------+
//|                                    Naive Bayes theory script.mq5 |
//|                                    Copyright 2022, Fxalgebra.com |
//|                        https://www.mql5.com/en/users/omegajoctan |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, Fxalgebra.com"
#property link      "https://www.mql5.com/en/users/omegajoctan"
#property version   "1.00"

//#define  DEBUG_MODE

#include <Naive Bayes.mqh>
#include <matrix_utils.mqh>
#include <metrics.mqh>

CMatrixutils matrix_utils;
CMetrics metrics;

CNaiveBayes  *naive_bayes;
CGaussianNaiveBayes *gaussian_naive;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   
   matrix Matrix = matrix_utils.ReadCsvEncode("weather dataset.csv");
   
   int cols[3] = {1,2,3};
   
   matrix_utils.RemoveMultCols(Matrix, cols);
   ArrayRemove(matrix_utils.csv_header,1,3);
   
   ArrayPrint(matrix_utils.csv_header);
   Print(Matrix);
   
   matrix x_matrix; vector y_vector;
   
   matrix_utils.XandYSplitMatrices(Matrix, x_matrix, y_vector);
   
   naive_bayes = new CNaiveBayes(x_matrix, y_vector);
   
   vector v = {0};
   
   naive_bayes.NaiveBayes(v);
   
   delete (naive_bayes);

//--- Gaussian naive bayes

   Matrix = matrix_utils.ReadCsv("gender dataset.csv");
   
   ArrayPrint(matrix_utils.csv_header);
   Print(Matrix);
   
   matrix_utils.XandYSplitMatrices(Matrix, x_matrix, y_vector);
   
   gaussian_naive = new CGaussianNaiveBayes(x_matrix, y_vector);
   
   vector person = {5.3, 140, 7.5};
   
   Print("The Person is a ",gaussian_naive.GaussianNaiveBayes(person));
   
   vector F = gaussian_naive.GaussianNaiveBayes(x_matrix); //pass the predictions to the Forecast vector
   metrics.confusion_matrix(y_vector,F, gaussian_naive.classes);
   
   delete (gaussian_naive);
  }
//+------------------------------------------------------------------+
